/*
 * clGeniviAudioSource.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLGENIVIAUDIOSOURCE_H_
#define CLGENIVIAUDIOSOURCE_H_


#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources.h"
#include "AudioStack/clAudioSource.h"



namespace AudioStack
{

class clGeniviAudioSource : public clAudioSource
{
public:
   /**
    * Get the Genivi SourceID of the Source provided by Parameter
    * @param enSrcId ID of the AudioStackInternal Identifier
    * @param u8SubSource the SubSource ID
    * @return tU16 Genivi AudioManager sourceID of given AudioSource, Subsource tupel
    */
   static tU16 u16GetGeniviSourceID(SourceID srcID);

   /**
    * Get the Genivi SourceID of this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU16 u16GetGeniviSourceID();

   /**
    * Get the Subsource ID of this this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU8 u8GetSubsourceID();

   /**
    * Get the availability state of source
    */
   clAudioSource::enSourceAvailability enIsSourceAvailable();


   clGeniviAudioSource(SourceID srcId);
   virtual ~clGeniviAudioSource();
   virtual tVoid vMW_CCAResponse(tS32 extSrcID, enSourceActivity activity);
   virtual tVoid vMW_On();
   virtual tVoid vMW_Off(SourceID possibleNextSrc);
   virtual tVoid vMW_Pause(SourceID possibleNextSrc);
   virtual tVoid vReset();
   virtual tVoid vPrint();
   virtual tVoid vSourceAvailablilityChange(enSourceAvailability availability, enSourceAvailabilityReason availabilityReason);

protected:
   clAudioSource::enSourceAvailability mapAvailability(am_Availability_e avail);
   am_Availability_e mapAvailability(clAudioSource::enSourceAvailability);

   am::am_Handle_s*            m_gam_handle;
   am::am_connectionID_t       m_gam_connectionId;
   am::am_Source_s             m_gam_source_s;
private:
   clGeniviAudioSource();
};

} //namespace


#endif /* CLGENIVIAUDIOSOURCE_H_ */

